package gov.va.vamf.scheduling.varutility.security;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(locations = { "classpath:applicationContext-test.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class MdwsKeysVoterTest {
	MdwsKeysVoter<String> voter;

	@Before
	public void setup() {
		voter = new MdwsKeysVoter<String>();
	}

	@Test
	public void supportsConfigAttributeTest() {
		ConfigAttribute goodAttr = new ConfigAttribute() {
			@Override
			public String getAttribute() {
				return "MDWS_KEYS";
			}
		};
		ConfigAttribute badAttr = new ConfigAttribute() {
			@Override
			public String getAttribute() {
				return "";
			}
		};

		assert(voter.supports(goodAttr));
		assert(!voter.supports(badAttr));
	}

	@Test
	public void supportsClassTest() {
		assert(voter.supports(String.class));
	}

	@Test
	public void voteTest() {
		//TODO
	}
}
